<?php

$options = apply_filters(
	'colormag_breadcrumb_options',
	array(
		'colormag_sticky_header_heading' => array(
			'type'         => 'customind-accordion',
			'title'        => esc_html__( 'Sticky Header', 'colormag' ),
			'section'      => 'colormag_sticky_header_section',
			'sub_controls' => apply_filters(
				'colormag_sticky_controls',
				array(
					'colormag_sticky_header_general_subtitle' => array(
						'type'    => 'customind-title',
						'title'   => esc_html__( 'General', 'colormag' ),
						'section' => 'colormag_sticky_header_section',
					),
					'colormag_enable_sticky_menu'    => array(
						'title'   => esc_html__( 'Enable', 'colormag' ),
						'default' => 0,
						'type'    => 'customind-toggle',
						'section' => 'colormag_sticky_header_section',
					),
					'colormag_sticky_header_divider' => array(
						'type'      => 'customind-divider',
						'variant'   => 'dashed',
						'section'   => 'colormag_sticky_header_section',
						'condition' => array(
							'colormag_enable_sticky_menu' => true,
						),
					),
					'colormag_sticky_header_style_subtitle' => array(
						'title'     => esc_html__( 'Style', 'colormag' ),
						'type'      => 'customind-title',
						'section'   => 'colormag_sticky_header_section',
						'condition' => array(
							'colormag_enable_sticky_menu' => true,
						),
					),
					'colormag_sticky_menu_type'      => array(
						'default'   => 'sticky',
						'type'      => 'customind-select',
						'title'     => esc_html__( 'Effect', 'colormag' ),
						'section'   => 'colormag_sticky_header_section',
						'choices'   => array(
							'sticky'           => esc_html__( 'Default', 'colormag' ),
							'reveal_on_scroll' => esc_html__( 'Scroll Up', 'colormag' ),
						),
						'condition' => array(
							'colormag_enable_sticky_menu' => true,
						),
					),
				),
			),
			'collapsible'  => apply_filters( 'colormag_sticky_accordion_collapsible', false ),
		),

	)
);

colormag_customind()->add_controls( $options );
